	function PLOT_MAG_Z_LS(wT, H, MAG_n, MAG_p, Ylabel)
	
	% 	Plots the magnitude in linear scale given the frequency response 
	%	of a digital filter
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2007-10-07
	% 	Modified by: 	LW 2008-07-09	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	
 
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================		 
	
	if MAG_n < 0
		plot(wT, H,'linewidth', 2); 
	else	
		plot(wT, abs(H),'linewidth', 2); 
	end
	axis([min(wT), max(wT), MAG_n, MAG_p]);	
	set(gca,'FontName', 'times','FontSize', 16);

	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
 	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};	
	
 % ax = [0  0.2*pi  0.4*pi 0.6*pi  0.8*pi  pi];
%	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};	

	 
	fs = 14;
	x = floor(max(wT)*10/pi);
	%	for n = 9:-1:x
	%		ax(end) = [];	lab(end) = [];
	%	end
	
	x = 0;			% Modify if needed
	while x < min(wT)
		x = x + ax(1);
		ax(1) = [];
		lab(1) = [];
	end
	x = pi; 
	while x < max(wT)
		x = x - ax(1);
		ax(1) = [];
		lab(1) = [];
	end

	if max(wT) <= 0.05*pi
		ax = [0 0.025*pi 0.05*pi];
		lab = {'0';'0.025\pi';'0.05\pi'};
	elseif max(wT) <= 0.1*pi
		ax = [0 0.06*pi 0.1*pi];
		lab = {'0';'0.05\pi';'0.1\pi'};	
	elseif max(wT) <= 0.2*pi
		ax = [0 0.05*pi 0.1*pi 0.15*pi 0.2*pi];
		lab = {'0';'0.05\pi';'0.1\pi';'0.15\pi';'0.2\pi'};
	elseif max(wT) <= 0.3*pi
		ax = [0 0.1*pi 0.2*pi 0.3*pi];
		lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi'};
	elseif max(wT) <= 0.4*pi
		ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi];
		lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi'};	
	end
	if Ylabel ~= '-'
		ylabel(['{|\it' Ylabel '}({\ite^j^\omega^T})|'],'FontName', fn,'FontSize',fs);
	end
 	xlabel('{\it\omegaT} [rad]');	
	xtick(ax,lab);
	grid on;
	box on
 
